/// <reference types="node" />
import { WalletLinkConnection, WalletLinkConnectionUpdateListener } from './connection/WalletLinkConnection';
import { EthereumTransactionParams } from './type/EthereumTransactionParams';
import { WalletLinkEventData, WalletLinkResponseEventData } from './type/WalletLinkEventData';
import { WalletLinkSession } from './type/WalletLinkSession';
import { SupportedWeb3Method, Web3Request } from './type/Web3Request';
import { Web3Response } from './type/Web3Response';
import { RelayUI } from './ui/RelayUI';
import { WalletLinkRelayUI } from './ui/WalletLinkRelayUI';
import { WLMobileRelayUI } from './ui/WLMobileRelayUI';
import { AddressString, IntNumber, RegExpString } from '../../../core/type';
import { ScopedLocalStorage } from '../../../util/ScopedLocalStorage';
interface WalletLinkRelayOptions {
    linkAPIUrl: string;
    storage: ScopedLocalStorage;
}
export declare class WalletLinkRelay implements WalletLinkConnectionUpdateListener {
    private static accountRequestCallbackIds;
    private readonly linkAPIUrl;
    protected readonly storage: ScopedLocalStorage;
    private _session;
    private readonly relayEventManager;
    protected connection: WalletLinkConnection;
    private accountsCallback;
    private chainCallbackParams;
    private chainCallback;
    protected dappDefaultChain: number;
    protected ui: RelayUI;
    private isMobileWeb;
    protected appName: string;
    protected appLogoUrl: string | null;
    isLinked: boolean | undefined;
    isUnlinkedErrorState: boolean | undefined;
    constructor(options: Readonly<WalletLinkRelayOptions>);
    subscribe(): {
        session: WalletLinkSession;
        ui: WalletLinkRelayUI | WLMobileRelayUI;
        connection: WalletLinkConnection;
    };
    linkedUpdated: (linked: boolean) => void;
    metadataUpdated: (key: string, value: string) => void;
    chainUpdated: (chainId: string, jsonRpcUrl: string) => void;
    accountUpdated: (selectedAddress: string) => void;
    attachUI(): void;
    resetAndReload(): void;
    setAppInfo(appName: string, appLogoUrl: string | null): void;
    getStorageItem(key: string): string | null;
    setStorageItem(key: string, value: string): void;
    signEthereumMessage(message: Buffer, address: AddressString, addPrefix: boolean, typedDataJson?: string | null): Promise<Web3Response<"signEthereumMessage">>;
    ethereumAddressFromSignedMessage(message: Buffer, signature: Buffer, addPrefix: boolean): Promise<Web3Response<"ethereumAddressFromSignedMessage">>;
    signEthereumTransaction(params: EthereumTransactionParams): Promise<Web3Response<"signEthereumTransaction">>;
    signAndSubmitEthereumTransaction(params: EthereumTransactionParams): Promise<Web3Response<"submitEthereumTransaction">>;
    submitEthereumTransaction(signedTransaction: Buffer, chainId: IntNumber): Promise<Web3Response<"submitEthereumTransaction">>;
    scanQRCode(regExp: RegExpString): Promise<Web3Response<"scanQRCode">>;
    getWalletLinkSession(): WalletLinkSession;
    genericRequest(data: object, action: string): Promise<Web3Response<"generic">>;
    sendGenericMessage(request: Web3Request<'generic'>): Promise<Web3Response<'generic'>>;
    sendRequest<RequestMethod extends SupportedWeb3Method, ResponseMethod extends SupportedWeb3Method = RequestMethod, Response = Web3Response<ResponseMethod>>(request: Web3Request<RequestMethod>): Promise<Response>;
    setAccountsCallback(accountsCallback: (accounts: string[], isDisconnect?: boolean) => void): void;
    setChainCallback(chainCallback: (chainId: string, jsonRpcUrl: string) => void): void;
    setDappDefaultChainCallback(chainId: number): void;
    protected publishWeb3RequestEvent(id: string, request: Web3Request): void;
    private openCoinbaseWalletDeeplink;
    private publishWeb3RequestCanceledEvent;
    protected publishEvent(event: string, message: WalletLinkEventData, callWebhook: boolean): Promise<string>;
    handleWeb3ResponseMessage(message: WalletLinkResponseEventData): void;
    private handleErrorResponse;
    private invokeCallback;
    requestEthereumAccounts(): Promise<Web3Response<"requestEthereumAccounts">>;
    watchAsset(type: string, address: string, symbol?: string, decimals?: number, image?: string, chainId?: string): Promise<Web3Response<'watchAsset'>>;
    addEthereumChain(chainId: string, rpcUrls: string[], iconUrls: string[], blockExplorerUrls: string[], chainName?: string, nativeCurrency?: {
        name: string;
        symbol: string;
        decimals: number;
    }): Promise<Web3Response<"addEthereumChain">>;
    switchEthereumChain(chainId: string, address?: string): Promise<Web3Response<'switchEthereumChain'>>;
}
export {};
