"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  CURRENT_DEV_INSTANCE_SUFFIXES: () => CURRENT_DEV_INSTANCE_SUFFIXES,
  ClerkAPIResponseError: () => ClerkAPIResponseError,
  ClerkRuntimeError: () => ClerkRuntimeError,
  ClerkWebAuthnError: () => ClerkWebAuthnError,
  DEV_BROWSER_JWT_KEY: () => DEV_BROWSER_JWT_KEY,
  DEV_OR_STAGING_SUFFIXES: () => DEV_OR_STAGING_SUFFIXES,
  EmailLinkError: () => EmailLinkError,
  EmailLinkErrorCode: () => EmailLinkErrorCode,
  LEGACY_DEV_INSTANCE_SUFFIXES: () => LEGACY_DEV_INSTANCE_SUFFIXES,
  LOCAL_API_URL: () => LOCAL_API_URL,
  LOCAL_ENV_SUFFIXES: () => LOCAL_ENV_SUFFIXES,
  LocalStorageBroadcastChannel: () => LocalStorageBroadcastChannel,
  PROD_API_URL: () => PROD_API_URL,
  Poller: () => Poller,
  STAGING_API_URL: () => STAGING_API_URL,
  STAGING_ENV_SUFFIXES: () => STAGING_ENV_SUFFIXES,
  addClerkPrefix: () => addClerkPrefix,
  addYears: () => addYears,
  apiUrlFromPublishableKey: () => apiUrlFromPublishableKey,
  applyFunctionToObj: () => applyFunctionToObj,
  buildClerkJsScriptAttributes: () => buildClerkJsScriptAttributes,
  buildErrorThrower: () => buildErrorThrower,
  buildPublishableKey: () => buildPublishableKey,
  callWithRetry: () => callWithRetry,
  camelToSnake: () => camelToSnake,
  cleanDoubleSlashes: () => cleanDoubleSlashes,
  clerkJsScriptUrl: () => clerkJsScriptUrl,
  colorToSameTypeString: () => colorToSameTypeString,
  createDeferredPromise: () => createDeferredPromise,
  createDevOrStagingUrlCache: () => createDevOrStagingUrlCache,
  createWorkerTimers: () => createWorkerTimers,
  dateTo12HourTime: () => dateTo12HourTime,
  deepCamelToSnake: () => deepCamelToSnake,
  deepSnakeToCamel: () => deepSnakeToCamel,
  deprecated: () => deprecated,
  deprecatedObjectProperty: () => deprecatedObjectProperty,
  deprecatedProperty: () => deprecatedProperty,
  deriveState: () => deriveState,
  differenceInCalendarDays: () => differenceInCalendarDays,
  extension: () => extension,
  extractDevBrowserJWTFromURL: () => extractDevBrowserJWTFromURL,
  fastDeepMergeAndKeep: () => fastDeepMergeAndKeep,
  fastDeepMergeAndReplace: () => fastDeepMergeAndReplace,
  filterProps: () => filterProps,
  formatRelative: () => formatRelative,
  getClerkJsMajorVersionOrTag: () => getClerkJsMajorVersionOrTag,
  getCookieSuffix: () => getCookieSuffix,
  getNonUndefinedValues: () => getNonUndefinedValues,
  getScriptUrl: () => getScriptUrl,
  getSuffixedCookieName: () => getSuffixedCookieName,
  handleValueOrFn: () => handleValueOrFn,
  hasAlpha: () => hasAlpha,
  hasLeadingSlash: () => hasLeadingSlash,
  hasTrailingSlash: () => hasTrailingSlash,
  hexStringToRgbaColor: () => hexStringToRgbaColor,
  iconImageUrl: () => iconImageUrl,
  inBrowser: () => inBrowser,
  is4xxError: () => is4xxError,
  isAbsoluteUrl: () => isAbsoluteUrl,
  isBrowserOnline: () => isBrowserOnline,
  isCaptchaError: () => isCaptchaError,
  isClerkAPIResponseError: () => isClerkAPIResponseError,
  isClerkRuntimeError: () => isClerkRuntimeError,
  isCurrentDevAccountPortalOrigin: () => isCurrentDevAccountPortalOrigin,
  isDevelopmentEnvironment: () => isDevelopmentEnvironment,
  isDevelopmentFromPublishableKey: () => isDevelopmentFromPublishableKey,
  isDevelopmentFromSecretKey: () => isDevelopmentFromSecretKey,
  isEmailLinkError: () => isEmailLinkError,
  isHSLColor: () => isHSLColor,
  isHttpOrHttps: () => isHttpOrHttps,
  isIPV4Address: () => isIPV4Address,
  isKnownError: () => isKnownError,
  isLegacyDevAccountPortalOrigin: () => isLegacyDevAccountPortalOrigin,
  isMetamaskError: () => isMetamaskError,
  isNetworkError: () => isNetworkError,
  isNonEmptyURL: () => isNonEmptyURL,
  isPasswordPwnedError: () => isPasswordPwnedError,
  isProductionEnvironment: () => isProductionEnvironment,
  isProductionFromPublishableKey: () => isProductionFromPublishableKey,
  isProductionFromSecretKey: () => isProductionFromSecretKey,
  isProxyUrlRelative: () => isProxyUrlRelative,
  isPublishableKey: () => isPublishableKey,
  isRGBColor: () => isRGBColor,
  isStaging: () => isStaging,
  isTestEnvironment: () => isTestEnvironment,
  isTransparent: () => isTransparent,
  isTruthy: () => isTruthy,
  isUnauthorizedError: () => isUnauthorizedError,
  isUserLockedError: () => isUserLockedError,
  isValidBrowser: () => isValidBrowser,
  isValidBrowserOnline: () => isValidBrowserOnline,
  isValidHexString: () => isValidHexString,
  isValidHslaString: () => isValidHslaString,
  isValidProxyUrl: () => isValidProxyUrl,
  isValidRgbaString: () => isValidRgbaString,
  isomorphicAtob: () => isomorphicAtob,
  isomorphicBtoa: () => isomorphicBtoa,
  joinURL: () => joinURL,
  loadClerkJsScript: () => loadClerkJsScript,
  loadScript: () => loadScript,
  logErrorInDevMode: () => logErrorInDevMode,
  logger: () => logger,
  noop: () => noop,
  normalizeDate: () => normalizeDate,
  parseError: () => parseError,
  parseErrors: () => parseErrors,
  parsePublishableKey: () => parsePublishableKey,
  parseSearchParams: () => parseSearchParams,
  proxyUrlToAbsoluteURL: () => proxyUrlToAbsoluteURL,
  readJSONFile: () => readJSONFile,
  removeUndefined: () => removeUndefined,
  runWithExponentialBackOff: () => runWithExponentialBackOff,
  setClerkJsLoadingErrorPackageName: () => setClerkJsLoadingErrorPackageName,
  setDevBrowserJWTInURL: () => setDevBrowserJWTInURL,
  snakeToCamel: () => snakeToCamel,
  stringToHslaColor: () => stringToHslaColor,
  stringToSameTypeColor: () => stringToSameTypeColor,
  stripScheme: () => stripScheme,
  titleize: () => titleize,
  toSentence: () => toSentence,
  userAgentIsRobot: () => userAgentIsRobot,
  versionSelector: () => versionSelector,
  withLeadingSlash: () => withLeadingSlash,
  withTrailingSlash: () => withTrailingSlash,
  without: () => without,
  withoutLeadingSlash: () => withoutLeadingSlash,
  withoutTrailingSlash: () => withoutTrailingSlash
});
module.exports = __toCommonJS(src_exports);

// src/utils/noop.ts
var noop = (..._args) => {
};

// src/utils/createDeferredPromise.ts
var createDeferredPromise = () => {
  let resolve = noop;
  let reject = noop;
  const promise = new Promise((res, rej) => {
    resolve = res;
    reject = rej;
  });
  return { promise, resolve, reject };
};

// src/utils/instance.ts
function isStaging(frontendApi) {
  return frontendApi.endsWith(".lclstage.dev") || frontendApi.endsWith(".stgstage.dev") || frontendApi.endsWith(".clerkstage.dev") || frontendApi.endsWith(".accountsstage.dev");
}

// src/utils/runtimeEnvironment.ts
var isDevelopmentEnvironment = () => {
  try {
    return process.env.NODE_ENV === "development";
  } catch (err) {
  }
  return false;
};
var isTestEnvironment = () => {
  try {
    return process.env.NODE_ENV === "test";
  } catch (err) {
  }
  return false;
};
var isProductionEnvironment = () => {
  try {
    return process.env.NODE_ENV === "production";
  } catch (err) {
  }
  return false;
};

// src/utils/logErrorInDevMode.ts
var logErrorInDevMode = (message) => {
  if (isDevelopmentEnvironment()) {
    console.error(`Clerk: ${message}`);
  }
};

// src/utils/runWithExponentialBackOff.ts
var defaultOptions = {
  firstDelay: 125,
  maxDelay: 0,
  timeMultiple: 2,
  shouldRetry: () => true
};
var sleep = async (ms) => new Promise((s) => setTimeout(s, ms));
var createExponentialDelayAsyncFn = (opts) => {
  let timesCalled = 0;
  const calculateDelayInMs = () => {
    const constant = opts.firstDelay;
    const base = opts.timeMultiple;
    const delay = constant * Math.pow(base, timesCalled);
    return Math.min(opts.maxDelay || delay, delay);
  };
  return async () => {
    await sleep(calculateDelayInMs());
    timesCalled++;
  };
};
var runWithExponentialBackOff = async (callback, options = {}) => {
  let iterationsCount = 0;
  const { shouldRetry, firstDelay, maxDelay, timeMultiple } = {
    ...defaultOptions,
    ...options
  };
  const delay = createExponentialDelayAsyncFn({ firstDelay, maxDelay, timeMultiple });
  while (true) {
    try {
      return await callback();
    } catch (e) {
      iterationsCount++;
      if (!shouldRetry(e, iterationsCount)) {
        throw e;
      }
      await delay();
    }
  }
};

// src/utils/handleValueOrFn.ts
function handleValueOrFn(value, url, defaultValue) {
  if (typeof value === "function") {
    return value(url);
  }
  if (typeof value !== "undefined") {
    return value;
  }
  if (typeof defaultValue !== "undefined") {
    return defaultValue;
  }
  return void 0;
}

// src/utils/fastDeepMerge.ts
var fastDeepMergeAndReplace = (source, target) => {
  if (!source || !target) {
    return;
  }
  for (const key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key) && source[key] !== null && typeof source[key] === `object`) {
      if (target[key] === void 0) {
        target[key] = new (Object.getPrototypeOf(source[key])).constructor();
      }
      fastDeepMergeAndReplace(source[key], target[key]);
    } else if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
var fastDeepMergeAndKeep = (source, target) => {
  if (!source || !target) {
    return;
  }
  for (const key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key) && source[key] !== null && typeof source[key] === `object`) {
      if (target[key] === void 0) {
        target[key] = new (Object.getPrototypeOf(source[key])).constructor();
      }
      fastDeepMergeAndKeep(source[key], target[key]);
    } else if (Object.prototype.hasOwnProperty.call(source, key) && target[key] === void 0) {
      target[key] = source[key];
    }
  }
};

// src/constants.ts
var LEGACY_DEV_INSTANCE_SUFFIXES = [".lcl.dev", ".lclstage.dev", ".lclclerk.com"];
var CURRENT_DEV_INSTANCE_SUFFIXES = [".accounts.dev", ".accountsstage.dev", ".accounts.lclclerk.com"];
var DEV_OR_STAGING_SUFFIXES = [
  ".lcl.dev",
  ".stg.dev",
  ".lclstage.dev",
  ".stgstage.dev",
  ".dev.lclclerk.com",
  ".stg.lclclerk.com",
  ".accounts.lclclerk.com",
  "accountsstage.dev",
  "accounts.dev"
];
var LOCAL_ENV_SUFFIXES = [".lcl.dev", "lclstage.dev", ".lclclerk.com", ".accounts.lclclerk.com"];
var STAGING_ENV_SUFFIXES = [".accountsstage.dev"];
var LOCAL_API_URL = "https://api.lclclerk.com";
var STAGING_API_URL = "https://api.clerkstage.dev";
var PROD_API_URL = "https://api.clerk.com";
function iconImageUrl(id, format = "svg") {
  return `https://img.clerk.com/static/${id}.${format}`;
}

// src/isomorphicAtob.ts
var isomorphicAtob = (data) => {
  if (typeof atob !== "undefined" && typeof atob === "function") {
    return atob(data);
  } else if (typeof global !== "undefined" && global.Buffer) {
    return new global.Buffer(data, "base64").toString();
  }
  return data;
};

// src/isomorphicBtoa.ts
var isomorphicBtoa = (data) => {
  if (typeof btoa !== "undefined" && typeof btoa === "function") {
    return btoa(data);
  } else if (typeof global !== "undefined" && global.Buffer) {
    return new global.Buffer(data).toString("base64");
  }
  return data;
};

// src/keys.ts
var PUBLISHABLE_KEY_LIVE_PREFIX = "pk_live_";
var PUBLISHABLE_KEY_TEST_PREFIX = "pk_test_";
var PUBLISHABLE_FRONTEND_API_DEV_REGEX = /^(([a-z]+)-){2}([0-9]{1,2})\.clerk\.accounts([a-z.]*)(dev|com)$/i;
function buildPublishableKey(frontendApi) {
  const isDevKey = PUBLISHABLE_FRONTEND_API_DEV_REGEX.test(frontendApi) || frontendApi.startsWith("clerk.") && LEGACY_DEV_INSTANCE_SUFFIXES.some((s) => frontendApi.endsWith(s));
  const keyPrefix = isDevKey ? PUBLISHABLE_KEY_TEST_PREFIX : PUBLISHABLE_KEY_LIVE_PREFIX;
  return `${keyPrefix}${isomorphicBtoa(`${frontendApi}$`)}`;
}
function parsePublishableKey(key, options = {}) {
  key = key || "";
  if (!key || !isPublishableKey(key)) {
    if (options.fatal) {
      throw new Error("Publishable key not valid.");
    }
    return null;
  }
  const instanceType = key.startsWith(PUBLISHABLE_KEY_LIVE_PREFIX) ? "production" : "development";
  let frontendApi = isomorphicAtob(key.split("_")[2]);
  frontendApi = frontendApi.slice(0, -1);
  if (options.proxyUrl) {
    frontendApi = options.proxyUrl;
  } else if (instanceType !== "development" && options.domain) {
    frontendApi = `clerk.${options.domain}`;
  }
  return {
    instanceType,
    frontendApi
  };
}
function isPublishableKey(key) {
  key = key || "";
  const hasValidPrefix = key.startsWith(PUBLISHABLE_KEY_LIVE_PREFIX) || key.startsWith(PUBLISHABLE_KEY_TEST_PREFIX);
  const hasValidFrontendApiPostfix = isomorphicAtob(key.split("_")[2] || "").endsWith("$");
  return hasValidPrefix && hasValidFrontendApiPostfix;
}
function createDevOrStagingUrlCache() {
  const devOrStagingUrlCache = /* @__PURE__ */ new Map();
  return {
    isDevOrStagingUrl: (url) => {
      if (!url) {
        return false;
      }
      const hostname = typeof url === "string" ? url : url.hostname;
      let res = devOrStagingUrlCache.get(hostname);
      if (res === void 0) {
        res = DEV_OR_STAGING_SUFFIXES.some((s) => hostname.endsWith(s));
        devOrStagingUrlCache.set(hostname, res);
      }
      return res;
    }
  };
}
function isDevelopmentFromPublishableKey(apiKey) {
  return apiKey.startsWith("test_") || apiKey.startsWith("pk_test_");
}
function isProductionFromPublishableKey(apiKey) {
  return apiKey.startsWith("live_") || apiKey.startsWith("pk_live_");
}
function isDevelopmentFromSecretKey(apiKey) {
  return apiKey.startsWith("test_") || apiKey.startsWith("sk_test_");
}
function isProductionFromSecretKey(apiKey) {
  return apiKey.startsWith("live_") || apiKey.startsWith("sk_live_");
}
async function getCookieSuffix(publishableKey, subtle = globalThis.crypto.subtle) {
  const data = new TextEncoder().encode(publishableKey);
  const digest = await subtle.digest("sha-1", data);
  const stringDigest = String.fromCharCode(...new Uint8Array(digest));
  return isomorphicBtoa(stringDigest).replace(/\+/gi, "-").replace(/\//gi, "_").substring(0, 8);
}
var getSuffixedCookieName = (cookieName, cookieSuffix) => {
  return `${cookieName}_${cookieSuffix}`;
};

// src/apiUrlFromPublishableKey.ts
var apiUrlFromPublishableKey = (publishableKey) => {
  var _a;
  const frontendApi = (_a = parsePublishableKey(publishableKey)) == null ? void 0 : _a.frontendApi;
  if ((frontendApi == null ? void 0 : frontendApi.startsWith("clerk.")) && LEGACY_DEV_INSTANCE_SUFFIXES.some((suffix) => frontendApi == null ? void 0 : frontendApi.endsWith(suffix))) {
    return PROD_API_URL;
  }
  if (LOCAL_ENV_SUFFIXES.some((suffix) => frontendApi == null ? void 0 : frontendApi.endsWith(suffix))) {
    return LOCAL_API_URL;
  }
  if (STAGING_ENV_SUFFIXES.some((suffix) => frontendApi == null ? void 0 : frontendApi.endsWith(suffix))) {
    return STAGING_API_URL;
  }
  return PROD_API_URL;
};

// src/browser.ts
function inBrowser() {
  return typeof window !== "undefined";
}
var botAgents = [
  "bot",
  "spider",
  "crawl",
  "APIs-Google",
  "AdsBot",
  "Googlebot",
  "mediapartners",
  "Google Favicon",
  "FeedFetcher",
  "Google-Read-Aloud",
  "DuplexWeb-Google",
  "googleweblight",
  "bing",
  "yandex",
  "baidu",
  "duckduck",
  "yahoo",
  "ecosia",
  "ia_archiver",
  "facebook",
  "instagram",
  "pinterest",
  "reddit",
  "slack",
  "twitter",
  "whatsapp",
  "youtube",
  "semrush"
];
var botAgentRegex = new RegExp(botAgents.join("|"), "i");
function userAgentIsRobot(userAgent) {
  return !userAgent ? false : botAgentRegex.test(userAgent);
}
function isValidBrowser() {
  const navigator = inBrowser() ? window == null ? void 0 : window.navigator : null;
  if (!navigator) {
    return false;
  }
  return !userAgentIsRobot(navigator == null ? void 0 : navigator.userAgent) && !(navigator == null ? void 0 : navigator.webdriver);
}
function isBrowserOnline() {
  var _a, _b;
  const navigator = inBrowser() ? window == null ? void 0 : window.navigator : null;
  if (!navigator) {
    return false;
  }
  const isNavigatorOnline = navigator == null ? void 0 : navigator.onLine;
  const isExperimentalConnectionOnline = ((_a = navigator == null ? void 0 : navigator.connection) == null ? void 0 : _a.rtt) !== 0 && ((_b = navigator == null ? void 0 : navigator.connection) == null ? void 0 : _b.downlink) !== 0;
  return isExperimentalConnectionOnline && isNavigatorOnline;
}
function isValidBrowserOnline() {
  return isBrowserOnline() && isValidBrowser();
}

// src/callWithRetry.ts
function wait(ms) {
  return new Promise((res) => setTimeout(res, ms));
}
var MAX_NUMBER_OF_RETRIES = 5;
async function callWithRetry(fn, attempt = 1, maxAttempts = MAX_NUMBER_OF_RETRIES) {
  try {
    return await fn();
  } catch (e) {
    if (attempt >= maxAttempts) {
      throw e;
    }
    await wait(2 ** attempt * 100);
    return callWithRetry(fn, attempt + 1, maxAttempts);
  }
}

// src/color.ts
var IS_HEX_COLOR_REGEX = /^#?([A-F0-9]{6}|[A-F0-9]{3})$/i;
var IS_RGB_COLOR_REGEX = /^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/i;
var IS_RGBA_COLOR_REGEX = /^rgba\((\d+),\s*(\d+),\s*(\d+)(,\s*\d+(\.\d+)?)\)$/i;
var IS_HSL_COLOR_REGEX = /^hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)$/i;
var IS_HSLA_COLOR_REGEX = /^hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%(,\s*\d+(\.\d+)?)*\)$/i;
var isValidHexString = (s) => {
  return !!s.match(IS_HEX_COLOR_REGEX);
};
var isValidRgbaString = (s) => {
  return !!(s.match(IS_RGB_COLOR_REGEX) || s.match(IS_RGBA_COLOR_REGEX));
};
var isValidHslaString = (s) => {
  return !!s.match(IS_HSL_COLOR_REGEX) || !!s.match(IS_HSLA_COLOR_REGEX);
};
var isRGBColor = (c) => {
  return typeof c !== "string" && "r" in c;
};
var isHSLColor = (c) => {
  return typeof c !== "string" && "h" in c;
};
var isTransparent = (c) => {
  return c === "transparent";
};
var hasAlpha = (color) => {
  return typeof color !== "string" && color.a != void 0 && color.a < 1;
};
var CLEAN_HSLA_REGEX = /[hsla()]/g;
var CLEAN_RGBA_REGEX = /[rgba()]/g;
var stringToHslaColor = (value) => {
  if (value === "transparent") {
    return { h: 0, s: 0, l: 0, a: 0 };
  }
  if (isValidHexString(value)) {
    return hexStringToHslaColor(value);
  }
  if (isValidHslaString(value)) {
    return parseHslaString(value);
  }
  if (isValidRgbaString(value)) {
    return rgbaStringToHslaColor(value);
  }
  return null;
};
var stringToSameTypeColor = (value) => {
  value = value.trim();
  if (isValidHexString(value)) {
    return value.startsWith("#") ? value : `#${value}`;
  }
  if (isValidRgbaString(value)) {
    return parseRgbaString(value);
  }
  if (isValidHslaString(value)) {
    return parseHslaString(value);
  }
  if (isTransparent(value)) {
    return value;
  }
  return "";
};
var colorToSameTypeString = (color) => {
  if (typeof color === "string" && (isValidHexString(color) || isTransparent(color))) {
    return color;
  }
  if (isRGBColor(color)) {
    return rgbaColorToRgbaString(color);
  }
  if (isHSLColor(color)) {
    return hslaColorToHslaString(color);
  }
  return "";
};
var hexStringToRgbaColor = (hex) => {
  hex = hex.replace("#", "");
  const r = parseInt(hex.substring(0, 2), 16);
  const g = parseInt(hex.substring(2, 4), 16);
  const b = parseInt(hex.substring(4, 6), 16);
  return { r, g, b };
};
var rgbaColorToRgbaString = (color) => {
  const { a, b, g, r } = color;
  return color.a === 0 ? "transparent" : color.a != void 0 ? `rgba(${r},${g},${b},${a})` : `rgb(${r},${g},${b})`;
};
var hslaColorToHslaString = (color) => {
  const { h, s, l, a } = color;
  const sPerc = Math.round(s * 100);
  const lPerc = Math.round(l * 100);
  return color.a === 0 ? "transparent" : color.a != void 0 ? `hsla(${h},${sPerc}%,${lPerc}%,${a})` : `hsl(${h},${sPerc}%,${lPerc}%)`;
};
var hexStringToHslaColor = (hex) => {
  const rgbaString = colorToSameTypeString(hexStringToRgbaColor(hex));
  return rgbaStringToHslaColor(rgbaString);
};
var rgbaStringToHslaColor = (rgba) => {
  const rgbaColor = parseRgbaString(rgba);
  const r = rgbaColor.r / 255;
  const g = rgbaColor.g / 255;
  const b = rgbaColor.b / 255;
  const max = Math.max(r, g, b), min = Math.min(r, g, b);
  let h, s;
  const l = (max + min) / 2;
  if (max == min) {
    h = s = 0;
  } else {
    const d = max - min;
    s = l >= 0.5 ? d / (2 - (max + min)) : d / (max + min);
    switch (max) {
      case r:
        h = (g - b) / d * 60;
        break;
      case g:
        h = ((b - r) / d + 2) * 60;
        break;
      default:
        h = ((r - g) / d + 4) * 60;
        break;
    }
  }
  const res = { h: Math.round(h), s, l };
  const a = rgbaColor.a;
  if (a != void 0) {
    res.a = a;
  }
  return res;
};
var parseRgbaString = (str) => {
  const [r, g, b, a] = str.replace(CLEAN_RGBA_REGEX, "").split(",").map((c) => Number.parseFloat(c));
  return { r, g, b, a };
};
var parseHslaString = (str) => {
  const [h, s, l, a] = str.replace(CLEAN_HSLA_REGEX, "").split(",").map((c) => Number.parseFloat(c));
  return { h, s: s / 100, l: l / 100, a };
};

// src/date.ts
var MILLISECONDS_IN_DAY = 864e5;
function dateTo12HourTime(date) {
  if (!date) {
    return "";
  }
  return date.toLocaleString("en-US", {
    hour: "2-digit",
    minute: "numeric",
    hour12: true
  });
}
function differenceInCalendarDays(a, b, { absolute = true } = {}) {
  if (!a || !b) {
    return 0;
  }
  const utcA = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
  const utcB = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
  const diff = Math.floor((utcB - utcA) / MILLISECONDS_IN_DAY);
  return absolute ? Math.abs(diff) : diff;
}
function normalizeDate(d) {
  try {
    return new Date(d || /* @__PURE__ */ new Date());
  } catch (e) {
    return /* @__PURE__ */ new Date();
  }
}
function formatRelative(props) {
  const { date, relativeTo } = props;
  if (!date || !relativeTo) {
    return null;
  }
  const a = normalizeDate(date);
  const b = normalizeDate(relativeTo);
  const differenceInDays = differenceInCalendarDays(b, a, { absolute: false });
  if (differenceInDays < -6) {
    return { relativeDateCase: "other", date: a };
  }
  if (differenceInDays < -1) {
    return { relativeDateCase: "previous6Days", date: a };
  }
  if (differenceInDays === -1) {
    return { relativeDateCase: "lastDay", date: a };
  }
  if (differenceInDays === 0) {
    return { relativeDateCase: "sameDay", date: a };
  }
  if (differenceInDays === 1) {
    return { relativeDateCase: "nextDay", date: a };
  }
  if (differenceInDays < 7) {
    return { relativeDateCase: "next6Days", date: a };
  }
  return { relativeDateCase: "other", date: a };
}
function addYears(initialDate, yearsToAdd) {
  const date = normalizeDate(initialDate);
  date.setFullYear(date.getFullYear() + yearsToAdd);
  return date;
}

// src/deprecated.ts
var displayedWarnings = /* @__PURE__ */ new Set();
var deprecated = (fnName, warning, key) => {
  const hideWarning = isTestEnvironment() || isProductionEnvironment();
  const messageId = key != null ? key : fnName;
  if (displayedWarnings.has(messageId) || hideWarning) {
    return;
  }
  displayedWarnings.add(messageId);
  console.warn(
    `Clerk - DEPRECATION WARNING: "${fnName}" is deprecated and will be removed in the next major release.
${warning}`
  );
};
var deprecatedProperty = (cls, propName, warning, isStatic = false) => {
  const target = isStatic ? cls : cls.prototype;
  let value = target[propName];
  Object.defineProperty(target, propName, {
    get() {
      deprecated(propName, warning, `${cls.name}:${propName}`);
      return value;
    },
    set(v) {
      value = v;
    }
  });
};
var deprecatedObjectProperty = (obj, propName, warning, key) => {
  let value = obj[propName];
  Object.defineProperty(obj, propName, {
    get() {
      deprecated(propName, warning, key);
      return value;
    },
    set(v) {
      value = v;
    }
  });
};

// src/deriveState.ts
var deriveState = (clerkLoaded, state, initialState) => {
  if (!clerkLoaded && initialState) {
    return deriveFromSsrInitialState(initialState);
  }
  return deriveFromClientSideState(state);
};
var deriveFromSsrInitialState = (initialState) => {
  const userId = initialState.userId;
  const user = initialState.user;
  const sessionId = initialState.sessionId;
  const session = initialState.session;
  const organization = initialState.organization;
  const orgId = initialState.orgId;
  const orgRole = initialState.orgRole;
  const orgPermissions = initialState.orgPermissions;
  const orgSlug = initialState.orgSlug;
  const actor = initialState.actor;
  const __experimental_factorVerificationAge = initialState.__experimental_factorVerificationAge;
  return {
    userId,
    user,
    sessionId,
    session,
    organization,
    orgId,
    orgRole,
    orgPermissions,
    orgSlug,
    actor,
    __experimental_factorVerificationAge
  };
};
var deriveFromClientSideState = (state) => {
  var _a;
  const userId = state.user ? state.user.id : state.user;
  const user = state.user;
  const sessionId = state.session ? state.session.id : state.session;
  const session = state.session;
  const __experimental_factorVerificationAge = state.session ? state.session.__experimental_factorVerificationAge : null;
  const actor = session == null ? void 0 : session.actor;
  const organization = state.organization;
  const orgId = state.organization ? state.organization.id : state.organization;
  const orgSlug = organization == null ? void 0 : organization.slug;
  const membership = organization ? (_a = user == null ? void 0 : user.organizationMemberships) == null ? void 0 : _a.find((om) => om.organization.id === orgId) : organization;
  const orgPermissions = membership ? membership.permissions : membership;
  const orgRole = membership ? membership.role : membership;
  return {
    userId,
    user,
    sessionId,
    session,
    organization,
    orgId,
    orgRole,
    orgSlug,
    orgPermissions,
    actor,
    __experimental_factorVerificationAge
  };
};

// src/error.ts
function isUnauthorizedError(e) {
  var _a, _b;
  const status = e == null ? void 0 : e.status;
  const code = (_b = (_a = e == null ? void 0 : e.errors) == null ? void 0 : _a[0]) == null ? void 0 : _b.code;
  return code === "authentication_invalid" && status === 401;
}
function isCaptchaError(e) {
  return ["captcha_invalid", "captcha_not_enabled", "captcha_missing_token"].includes(e.errors[0].code);
}
function is4xxError(e) {
  const status = e == null ? void 0 : e.status;
  return !!status && status >= 400 && status < 500;
}
function isNetworkError(e) {
  const message = (`${e.message}${e.name}` || "").toLowerCase().replace(/\s+/g, "");
  return message.includes("networkerror");
}
function isKnownError(error) {
  return isClerkAPIResponseError(error) || isMetamaskError(error) || isClerkRuntimeError(error);
}
function isClerkAPIResponseError(err) {
  return "clerkError" in err;
}
function isClerkRuntimeError(err) {
  return "clerkRuntimeError" in err;
}
function isMetamaskError(err) {
  return "code" in err && [4001, 32602, 32603].includes(err.code) && "message" in err;
}
function isUserLockedError(err) {
  var _a, _b;
  return isClerkAPIResponseError(err) && ((_b = (_a = err.errors) == null ? void 0 : _a[0]) == null ? void 0 : _b.code) === "user_locked";
}
function isPasswordPwnedError(err) {
  var _a, _b;
  return isClerkAPIResponseError(err) && ((_b = (_a = err.errors) == null ? void 0 : _a[0]) == null ? void 0 : _b.code) === "form_password_pwned";
}
function parseErrors(data = []) {
  return data.length > 0 ? data.map(parseError) : [];
}
function parseError(error) {
  var _a, _b, _c, _d, _e;
  return {
    code: error.code,
    message: error.message,
    longMessage: error.long_message,
    meta: {
      paramName: (_a = error == null ? void 0 : error.meta) == null ? void 0 : _a.param_name,
      sessionId: (_b = error == null ? void 0 : error.meta) == null ? void 0 : _b.session_id,
      emailAddresses: (_c = error == null ? void 0 : error.meta) == null ? void 0 : _c.email_addresses,
      identifiers: (_d = error == null ? void 0 : error.meta) == null ? void 0 : _d.identifiers,
      zxcvbn: (_e = error == null ? void 0 : error.meta) == null ? void 0 : _e.zxcvbn
    }
  };
}
var ClerkAPIResponseError = class _ClerkAPIResponseError extends Error {
  constructor(message, { data, status, clerkTraceId }) {
    super(message);
    this.toString = () => {
      let message = `[${this.name}]
Message:${this.message}
Status:${this.status}
Serialized errors: ${this.errors.map(
        (e) => JSON.stringify(e)
      )}`;
      if (this.clerkTraceId) {
        message += `
Clerk Trace ID: ${this.clerkTraceId}`;
      }
      return message;
    };
    Object.setPrototypeOf(this, _ClerkAPIResponseError.prototype);
    this.status = status;
    this.message = message;
    this.clerkTraceId = clerkTraceId;
    this.clerkError = true;
    this.errors = parseErrors(data);
  }
};
var ClerkRuntimeError = class _ClerkRuntimeError extends Error {
  constructor(message, { code }) {
    super(message);
    /**
     * Returns a string representation of the error.
     *
     * @returns {string} A formatted string with the error name and message.
     * @memberof ClerkRuntimeError
     */
    this.toString = () => {
      return `[${this.name}]
Message:${this.message}`;
    };
    Object.setPrototypeOf(this, _ClerkRuntimeError.prototype);
    this.code = code;
    this.message = message;
    this.clerkRuntimeError = true;
  }
};
var EmailLinkError = class _EmailLinkError extends Error {
  constructor(code) {
    super(code);
    this.code = code;
    Object.setPrototypeOf(this, _EmailLinkError.prototype);
  }
};
function isEmailLinkError(err) {
  return err instanceof EmailLinkError;
}
var EmailLinkErrorCode = {
  Expired: "expired",
  Failed: "failed",
  ClientMismatch: "client_mismatch"
};
var DefaultMessages = Object.freeze({
  InvalidProxyUrlErrorMessage: `The proxyUrl passed to Clerk is invalid. The expected value for proxyUrl is an absolute URL or a relative path with a leading '/'. (key={{url}})`,
  InvalidPublishableKeyErrorMessage: `The publishableKey passed to Clerk is invalid. You can get your Publishable key at https://dashboard.clerk.com/last-active?path=api-keys. (key={{key}})`,
  MissingPublishableKeyErrorMessage: `Missing publishableKey. You can get your key at https://dashboard.clerk.com/last-active?path=api-keys.`,
  MissingSecretKeyErrorMessage: `Missing secretKey. You can get your key at https://dashboard.clerk.com/last-active?path=api-keys.`,
  MissingClerkProvider: `{{source}} can only be used within the <ClerkProvider /> component. Learn more: https://clerk.com/docs/components/clerk-provider`
});
function buildErrorThrower({ packageName, customMessages }) {
  let pkg = packageName;
  const messages = {
    ...DefaultMessages,
    ...customMessages
  };
  function buildMessage(rawMessage, replacements) {
    if (!replacements) {
      return `${pkg}: ${rawMessage}`;
    }
    let msg = rawMessage;
    const matches = rawMessage.matchAll(/{{([a-zA-Z0-9-_]+)}}/g);
    for (const match of matches) {
      const replacement = (replacements[match[1]] || "").toString();
      msg = msg.replace(`{{${match[1]}}}`, replacement);
    }
    return `${pkg}: ${msg}`;
  }
  return {
    setPackageName({ packageName: packageName2 }) {
      if (typeof packageName2 === "string") {
        pkg = packageName2;
      }
      return this;
    },
    setMessages({ customMessages: customMessages2 }) {
      Object.assign(messages, customMessages2 || {});
      return this;
    },
    throwInvalidPublishableKeyError(params) {
      throw new Error(buildMessage(messages.InvalidPublishableKeyErrorMessage, params));
    },
    throwInvalidProxyUrl(params) {
      throw new Error(buildMessage(messages.InvalidProxyUrlErrorMessage, params));
    },
    throwMissingPublishableKeyError() {
      throw new Error(buildMessage(messages.MissingPublishableKeyErrorMessage));
    },
    throwMissingSecretKeyError() {
      throw new Error(buildMessage(messages.MissingSecretKeyErrorMessage));
    },
    throwMissingClerkProviderError(params) {
      throw new Error(buildMessage(messages.MissingClerkProvider, params));
    },
    throw(message) {
      throw new Error(buildMessage(message));
    }
  };
}
var ClerkWebAuthnError = class extends ClerkRuntimeError {
  constructor(message, { code }) {
    super(message, { code });
    this.code = code;
  }
};

// src/file.ts
function readJSONFile(file) {
  return new Promise((resolve, reject) => {
    const reader = new FileReader();
    reader.addEventListener("load", function() {
      const result = JSON.parse(reader.result);
      resolve(result);
    });
    reader.addEventListener("error", reject);
    reader.readAsText(file);
  });
}
var MimeTypeToExtensionMap = Object.freeze({
  "image/png": "png",
  "image/jpeg": "jpg",
  "image/gif": "gif",
  "image/webp": "webp",
  "image/x-icon": "ico",
  "image/vnd.microsoft.icon": "ico"
});
var extension = (mimeType) => {
  return MimeTypeToExtensionMap[mimeType];
};

// src/loadScript.ts
var NO_DOCUMENT_ERROR = "loadScript cannot be called when document does not exist";
var NO_SRC_ERROR = "loadScript cannot be called without a src";
async function loadScript(src = "", opts) {
  const { async, defer, beforeLoad, crossOrigin, nonce } = opts || {};
  const load = () => {
    return new Promise((resolve, reject) => {
      if (!src) {
        reject(NO_SRC_ERROR);
      }
      if (!document || !document.body) {
        reject(NO_DOCUMENT_ERROR);
      }
      const script = document.createElement("script");
      crossOrigin && script.setAttribute("crossorigin", crossOrigin);
      script.async = async || false;
      script.defer = defer || false;
      script.addEventListener("load", () => {
        script.remove();
        resolve(script);
      });
      script.addEventListener("error", () => {
        script.remove();
        reject();
      });
      script.src = src;
      script.nonce = nonce;
      beforeLoad == null ? void 0 : beforeLoad(script);
      document.body.appendChild(script);
    });
  };
  return runWithExponentialBackOff(load, { shouldRetry: (_, iterations) => iterations < 5 });
}

// src/proxy.ts
function isValidProxyUrl(key) {
  if (!key) {
    return true;
  }
  return isHttpOrHttps(key) || isProxyUrlRelative(key);
}
function isHttpOrHttps(key) {
  return /^http(s)?:\/\//.test(key || "");
}
function isProxyUrlRelative(key) {
  return key.startsWith("/");
}
function proxyUrlToAbsoluteURL(url) {
  if (!url) {
    return "";
  }
  return isProxyUrlRelative(url) ? new URL(url, window.location.origin).toString() : url;
}

// src/url.ts
function parseSearchParams(queryString = "") {
  if (queryString.startsWith("?")) {
    queryString = queryString.slice(1);
  }
  return new URLSearchParams(queryString);
}
function stripScheme(url = "") {
  return (url || "").replace(/^.+:\/\//, "");
}
function addClerkPrefix(str) {
  if (!str) {
    return "";
  }
  let regex;
  if (str.match(/^(clerk\.)+\w*$/)) {
    regex = /(clerk\.)*(?=clerk\.)/;
  } else if (str.match(/\.clerk.accounts/)) {
    return str;
  } else {
    regex = /^(clerk\.)*/gi;
  }
  const stripped = str.replace(regex, "");
  return `clerk.${stripped}`;
}
var getClerkJsMajorVersionOrTag = (frontendApi, version) => {
  if (!version && isStaging(frontendApi)) {
    return "canary";
  }
  if (!version) {
    return "latest";
  }
  return version.split(".")[0] || "latest";
};
var getScriptUrl = (frontendApi, { clerkJSVersion }) => {
  const noSchemeFrontendApi = frontendApi.replace(/http(s)?:\/\//, "");
  const major = getClerkJsMajorVersionOrTag(frontendApi, clerkJSVersion);
  return `https://${noSchemeFrontendApi}/npm/@clerk/clerk-js@${clerkJSVersion || major}/dist/clerk.browser.js`;
};
function isLegacyDevAccountPortalOrigin(host) {
  return LEGACY_DEV_INSTANCE_SUFFIXES.some((legacyDevSuffix) => {
    return host.startsWith("accounts.") && host.endsWith(legacyDevSuffix);
  });
}
function isCurrentDevAccountPortalOrigin(host) {
  return CURRENT_DEV_INSTANCE_SUFFIXES.some((currentDevSuffix) => {
    return host.endsWith(currentDevSuffix) && !host.endsWith(".clerk" + currentDevSuffix);
  });
}
var TRAILING_SLASH_RE = /\/$|\/\?|\/#/;
function hasTrailingSlash(input = "", respectQueryAndFragment) {
  if (!respectQueryAndFragment) {
    return input.endsWith("/");
  }
  return TRAILING_SLASH_RE.test(input);
}
function withTrailingSlash(input = "", respectQueryAndFragment) {
  if (!respectQueryAndFragment) {
    return input.endsWith("/") ? input : input + "/";
  }
  if (hasTrailingSlash(input, true)) {
    return input || "/";
  }
  let path = input;
  let fragment = "";
  const fragmentIndex = input.indexOf("#");
  if (fragmentIndex >= 0) {
    path = input.slice(0, fragmentIndex);
    fragment = input.slice(fragmentIndex);
    if (!path) {
      return fragment;
    }
  }
  const [s0, ...s] = path.split("?");
  return s0 + "/" + (s.length > 0 ? `?${s.join("?")}` : "") + fragment;
}
function withoutTrailingSlash(input = "", respectQueryAndFragment) {
  if (!respectQueryAndFragment) {
    return (hasTrailingSlash(input) ? input.slice(0, -1) : input) || "/";
  }
  if (!hasTrailingSlash(input, true)) {
    return input || "/";
  }
  let path = input;
  let fragment = "";
  const fragmentIndex = input.indexOf("#");
  if (fragmentIndex >= 0) {
    path = input.slice(0, fragmentIndex);
    fragment = input.slice(fragmentIndex);
  }
  const [s0, ...s] = path.split("?");
  return (s0.slice(0, -1) || "/") + (s.length > 0 ? `?${s.join("?")}` : "") + fragment;
}
function hasLeadingSlash(input = "") {
  return input.startsWith("/");
}
function withoutLeadingSlash(input = "") {
  return (hasLeadingSlash(input) ? input.slice(1) : input) || "/";
}
function withLeadingSlash(input = "") {
  return hasLeadingSlash(input) ? input : "/" + input;
}
function cleanDoubleSlashes(input = "") {
  return input.split("://").map((string_) => string_.replace(/\/{2,}/g, "/")).join("://");
}
function isNonEmptyURL(url) {
  return url && url !== "/";
}
var JOIN_LEADING_SLASH_RE = /^\.?\//;
function joinURL(base, ...input) {
  let url = base || "";
  for (const segment of input.filter((url2) => isNonEmptyURL(url2))) {
    if (url) {
      const _segment = segment.replace(JOIN_LEADING_SLASH_RE, "");
      url = withTrailingSlash(url) + _segment;
    } else {
      url = segment;
    }
  }
  return url;
}
var ABSOLUTE_URL_REGEX = /^[a-zA-Z][a-zA-Z\d+\-.]*?:/;
var isAbsoluteUrl = (url) => ABSOLUTE_URL_REGEX.test(url);

// src/versionSelector.ts
var versionSelector = (clerkJSVersion, packageVersion = "5.33.0") => {
  if (clerkJSVersion) {
    return clerkJSVersion;
  }
  const prereleaseTag = getPrereleaseTag(packageVersion);
  if (prereleaseTag) {
    if (prereleaseTag === "snapshot") {
      return "5.33.0";
    }
    return prereleaseTag;
  }
  return getMajorVersion(packageVersion);
};
var getPrereleaseTag = (packageVersion) => {
  var _a;
  return (_a = packageVersion.trim().replace(/^v/, "").match(/-(.+?)(\.|$)/)) == null ? void 0 : _a[1];
};
var getMajorVersion = (packageVersion) => packageVersion.trim().replace(/^v/, "").split(".")[0];

// src/loadClerkJsScript.ts
var FAILED_TO_LOAD_ERROR = "Clerk: Failed to load Clerk";
var { isDevOrStagingUrl } = createDevOrStagingUrlCache();
var errorThrower = buildErrorThrower({ packageName: "@clerk/shared" });
function setClerkJsLoadingErrorPackageName(packageName) {
  errorThrower.setPackageName({ packageName });
}
var loadClerkJsScript = async (opts) => {
  const existingScript = document.querySelector("script[data-clerk-js-script]");
  if (existingScript) {
    return new Promise((resolve, reject) => {
      existingScript.addEventListener("load", () => {
        resolve(existingScript);
      });
      existingScript.addEventListener("error", () => {
        reject(FAILED_TO_LOAD_ERROR);
      });
    });
  }
  if (!(opts == null ? void 0 : opts.publishableKey)) {
    errorThrower.throwMissingPublishableKeyError();
    return;
  }
  return loadScript(clerkJsScriptUrl(opts), {
    async: true,
    crossOrigin: "anonymous",
    nonce: opts.nonce,
    beforeLoad: applyClerkJsScriptAttributes(opts)
  }).catch(() => {
    throw new Error(FAILED_TO_LOAD_ERROR);
  });
};
var clerkJsScriptUrl = (opts) => {
  var _a, _b;
  const { clerkJSUrl, clerkJSVariant, clerkJSVersion, proxyUrl, domain, publishableKey } = opts;
  if (clerkJSUrl) {
    return clerkJSUrl;
  }
  let scriptHost = "";
  if (!!proxyUrl && isValidProxyUrl(proxyUrl)) {
    scriptHost = proxyUrlToAbsoluteURL(proxyUrl).replace(/http(s)?:\/\//, "");
  } else if (domain && !isDevOrStagingUrl(((_a = parsePublishableKey(publishableKey)) == null ? void 0 : _a.frontendApi) || "")) {
    scriptHost = addClerkPrefix(domain);
  } else {
    scriptHost = ((_b = parsePublishableKey(publishableKey)) == null ? void 0 : _b.frontendApi) || "";
  }
  const variant = clerkJSVariant ? `${clerkJSVariant.replace(/\.+$/, "")}.` : "";
  const version = versionSelector(clerkJSVersion);
  return `https://${scriptHost}/npm/@clerk/clerk-js@${version}/dist/clerk.${variant}browser.js`;
};
var buildClerkJsScriptAttributes = (options) => {
  const obj = {};
  if (options.publishableKey) {
    obj["data-clerk-publishable-key"] = options.publishableKey;
  }
  if (options.proxyUrl) {
    obj["data-clerk-proxy-url"] = options.proxyUrl;
  }
  if (options.domain) {
    obj["data-clerk-domain"] = options.domain;
  }
  if (options.nonce) {
    obj.nonce = options.nonce;
  }
  return obj;
};
var applyClerkJsScriptAttributes = (options) => (script) => {
  const attributes = buildClerkJsScriptAttributes(options);
  for (const attribute in attributes) {
    script.setAttribute(attribute, attributes[attribute]);
  }
};

// src/localStorageBroadcastChannel.ts
var KEY_PREFIX = "__lsbc__";
var LocalStorageBroadcastChannel = class {
  constructor(name) {
    this.eventTarget = window;
    this.postMessage = (data) => {
      if (typeof window === "undefined") {
        return;
      }
      try {
        window.localStorage.setItem(this.channelKey, JSON.stringify(data));
        window.localStorage.removeItem(this.channelKey);
      } catch (e) {
      }
    };
    this.addEventListener = (eventName, listener) => {
      this.eventTarget.addEventListener(this.prefixEventName(eventName), (e) => {
        listener(e);
      });
    };
    this.setupLocalStorageListener = () => {
      const notifyListeners = (e) => {
        if (e.key !== this.channelKey || !e.newValue) {
          return;
        }
        try {
          const data = JSON.parse(e.newValue || "");
          const event = new MessageEvent(this.prefixEventName("message"), {
            data
          });
          this.eventTarget.dispatchEvent(event);
        } catch (e2) {
        }
      };
      window.addEventListener("storage", notifyListeners);
    };
    this.channelKey = KEY_PREFIX + name;
    this.setupLocalStorageListener();
  }
  prefixEventName(eventName) {
    return this.channelKey + eventName;
  }
};

// src/workerTimers/workerTimers.worker.ts
var workerTimers_worker_default = 'const respond=r=>{self.postMessage(r)},workerToTabIds={};self.addEventListener("message",r=>{const e=r.data;switch(e.type){case"setTimeout":workerToTabIds[e.id]=setTimeout(()=>{respond({id:e.id})},e.ms);break;case"clearTimeout":workerToTabIds[e.id]&&(clearTimeout(workerToTabIds[e.id]),delete workerToTabIds[e.id]);break;case"setInterval":workerToTabIds[e.id]=setInterval(()=>{respond({id:e.id})},e.ms);break;case"clearInterval":workerToTabIds[e.id]&&(clearInterval(workerToTabIds[e.id]),delete workerToTabIds[e.id]);break}});\n';

// src/workerTimers/createWorkerTimers.ts
var createWebWorker = (source, opts = {}) => {
  if (typeof Worker === "undefined") {
    return null;
  }
  try {
    const blob = new Blob([source], { type: "application/javascript; charset=utf-8" });
    const workerScript = globalThis.URL.createObjectURL(blob);
    return new Worker(workerScript, opts);
  } catch (e) {
    console.warn("Clerk: Cannot create worker from blob. Consider adding worker-src blob:; to your CSP");
    return null;
  }
};
var fallbackTimers = () => {
  const setTimeout2 = globalThis.setTimeout.bind(globalThis);
  const setInterval = globalThis.setInterval.bind(globalThis);
  const clearTimeout = globalThis.clearTimeout.bind(globalThis);
  const clearInterval = globalThis.clearInterval.bind(globalThis);
  return { setTimeout: setTimeout2, setInterval, clearTimeout, clearInterval, cleanup: noop };
};
var createWorkerTimers = () => {
  let id = 0;
  const generateId = () => id++;
  const callbacks = /* @__PURE__ */ new Map();
  const post = (w, p) => w == null ? void 0 : w.postMessage(p);
  const handleMessage = (e) => {
    var _a;
    (_a = callbacks.get(e.data.id)) == null ? void 0 : _a();
  };
  let worker = createWebWorker(workerTimers_worker_default, { name: "clerk-timers" });
  worker == null ? void 0 : worker.addEventListener("message", handleMessage);
  if (!worker) {
    return fallbackTimers();
  }
  const init = () => {
    if (!worker) {
      worker = createWebWorker(workerTimers_worker_default, { name: "clerk-timers" });
      worker == null ? void 0 : worker.addEventListener("message", handleMessage);
    }
  };
  const cleanup = () => {
    if (worker) {
      worker.terminate();
      worker = null;
      callbacks.clear();
    }
  };
  const setTimeout2 = (cb, ms) => {
    init();
    const id2 = generateId();
    callbacks.set(id2, cb);
    post(worker, { type: "setTimeout", id: id2, ms });
    return id2;
  };
  const setInterval = (cb, ms) => {
    init();
    const id2 = generateId();
    callbacks.set(id2, cb);
    post(worker, { type: "setInterval", id: id2, ms });
    return id2;
  };
  const clearTimeout = (id2) => {
    init();
    callbacks.delete(id2);
    post(worker, { type: "clearTimeout", id: id2 });
  };
  const clearInterval = (id2) => {
    init();
    callbacks.delete(id2);
    post(worker, { type: "clearInterval", id: id2 });
  };
  return { setTimeout: setTimeout2, setInterval, clearTimeout, clearInterval, cleanup };
};

// src/poller.ts
function Poller({ delayInMs } = { delayInMs: 1e3 }) {
  const workerTimers = createWorkerTimers();
  let timerId;
  let stopped = false;
  const stop = () => {
    if (timerId) {
      workerTimers.clearTimeout(timerId);
      workerTimers.cleanup();
    }
    stopped = true;
  };
  const run = async (cb) => {
    stopped = false;
    await cb(stop);
    if (stopped) {
      return;
    }
    timerId = workerTimers.setTimeout(() => {
      void run(cb);
    }, delayInMs);
  };
  return { run, stop };
}

// src/underscore.ts
var toSentence = (items) => {
  if (items.length == 0) {
    return "";
  }
  if (items.length == 1) {
    return items[0];
  }
  let sentence = items.slice(0, -1).join(", ");
  sentence += `, or ${items.slice(-1)}`;
  return sentence;
};
var IP_V4_ADDRESS_REGEX = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
function isIPV4Address(str) {
  return IP_V4_ADDRESS_REGEX.test(str || "");
}
function titleize(str) {
  const s = str || "";
  return s.charAt(0).toUpperCase() + s.slice(1);
}
function snakeToCamel(str) {
  return str ? str.replace(/([-_][a-z])/g, (match) => match.toUpperCase().replace(/-|_/, "")) : "";
}
function camelToSnake(str) {
  return str ? str.replace(/[A-Z]/g, (letter) => `_${letter.toLowerCase()}`) : "";
}
var createDeepObjectTransformer = (transform) => {
  const deepTransform = (obj) => {
    if (!obj) {
      return obj;
    }
    if (Array.isArray(obj)) {
      return obj.map((el) => {
        if (typeof el === "object" || Array.isArray(el)) {
          return deepTransform(el);
        }
        return el;
      });
    }
    const copy = { ...obj };
    const keys = Object.keys(copy);
    for (const oldName of keys) {
      const newName = transform(oldName.toString());
      if (newName !== oldName) {
        copy[newName] = copy[oldName];
        delete copy[oldName];
      }
      if (typeof copy[newName] === "object") {
        copy[newName] = deepTransform(copy[newName]);
      }
    }
    return copy;
  };
  return deepTransform;
};
var deepCamelToSnake = createDeepObjectTransformer(camelToSnake);
var deepSnakeToCamel = createDeepObjectTransformer(snakeToCamel);
function isTruthy(value) {
  if (typeof value === `boolean`) {
    return value;
  }
  if (value === void 0 || value === null) {
    return false;
  }
  if (typeof value === `string`) {
    if (value.toLowerCase() === `true`) {
      return true;
    }
    if (value.toLowerCase() === `false`) {
      return false;
    }
  }
  const number = parseInt(value, 10);
  if (isNaN(number)) {
    return false;
  }
  if (number > 0) {
    return true;
  }
  return false;
}
function getNonUndefinedValues(obj) {
  return Object.entries(obj).reduce((acc, [key, value]) => {
    if (value !== void 0) {
      acc[key] = value;
    }
    return acc;
  }, {});
}

// src/object.ts
var without = (obj, ...props) => {
  const copy = { ...obj };
  for (const prop of props) {
    delete copy[prop];
  }
  return copy;
};
var removeUndefined = (obj) => {
  return Object.entries(obj).reduce((acc, [key, value]) => {
    if (value !== void 0 && value !== null) {
      acc[key] = value;
    }
    return acc;
  }, {});
};
var applyFunctionToObj = (obj, fn) => {
  const result = {};
  for (const key in obj) {
    result[key] = fn(obj[key], key);
  }
  return result;
};
var filterProps = (obj, filter) => {
  const result = {};
  for (const key in obj) {
    if (obj[key] && filter(obj[key])) {
      result[key] = obj[key];
    }
  }
  return result;
};

// src/logger.ts
var loggedMessages = /* @__PURE__ */ new Set();
var logger = {
  /**
   * A custom logger that ensures messages are logged only once.
   * Reduces noise and duplicated messages when logs are in a hot codepath.
   */
  warnOnce: (msg) => {
    if (loggedMessages.has(msg)) {
      return;
    }
    loggedMessages.add(msg);
    console.warn(msg);
  },
  logOnce: (msg) => {
    if (loggedMessages.has(msg)) {
      return;
    }
    console.log(msg);
    loggedMessages.add(msg);
  }
};

// src/devBrowser.ts
var DEV_BROWSER_JWT_KEY = "__clerk_db_jwt";
function setDevBrowserJWTInURL(url, jwt) {
  const resultURL = new URL(url);
  const jwtFromSearch = resultURL.searchParams.get(DEV_BROWSER_JWT_KEY);
  resultURL.searchParams.delete(DEV_BROWSER_JWT_KEY);
  const jwtToSet = jwtFromSearch || jwt;
  if (jwtToSet) {
    resultURL.searchParams.set(DEV_BROWSER_JWT_KEY, jwtToSet);
  }
  return resultURL;
}
function extractDevBrowserJWTFromURL(url) {
  const jwt = readDevBrowserJwtFromSearchParams(url);
  const cleanUrl = removeDevBrowserJwt(url);
  if (cleanUrl.href !== url.href && typeof globalThis.history !== "undefined") {
    globalThis.history.replaceState(null, "", removeDevBrowserJwt(url));
  }
  return jwt;
}
var readDevBrowserJwtFromSearchParams = (url) => {
  return url.searchParams.get(DEV_BROWSER_JWT_KEY) || "";
};
var removeDevBrowserJwt = (url) => {
  return removeDevBrowserJwtFromURLSearchParams(removeLegacyDevBrowserJwt(url));
};
var removeDevBrowserJwtFromURLSearchParams = (_url) => {
  const url = new URL(_url);
  url.searchParams.delete(DEV_BROWSER_JWT_KEY);
  return url;
};
var removeLegacyDevBrowserJwt = (_url) => {
  const DEV_BROWSER_JWT_MARKER_REGEXP = /__clerk_db_jwt\[(.*)\]/;
  const DEV_BROWSER_JWT_LEGACY_KEY = "__dev_session";
  const url = new URL(_url);
  url.searchParams.delete(DEV_BROWSER_JWT_LEGACY_KEY);
  url.hash = decodeURI(url.hash).replace(DEV_BROWSER_JWT_MARKER_REGEXP, "");
  if (url.href.endsWith("#")) {
    url.hash = "";
  }
  return url;
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CURRENT_DEV_INSTANCE_SUFFIXES,
  ClerkAPIResponseError,
  ClerkRuntimeError,
  ClerkWebAuthnError,
  DEV_BROWSER_JWT_KEY,
  DEV_OR_STAGING_SUFFIXES,
  EmailLinkError,
  EmailLinkErrorCode,
  LEGACY_DEV_INSTANCE_SUFFIXES,
  LOCAL_API_URL,
  LOCAL_ENV_SUFFIXES,
  LocalStorageBroadcastChannel,
  PROD_API_URL,
  Poller,
  STAGING_API_URL,
  STAGING_ENV_SUFFIXES,
  addClerkPrefix,
  addYears,
  apiUrlFromPublishableKey,
  applyFunctionToObj,
  buildClerkJsScriptAttributes,
  buildErrorThrower,
  buildPublishableKey,
  callWithRetry,
  camelToSnake,
  cleanDoubleSlashes,
  clerkJsScriptUrl,
  colorToSameTypeString,
  createDeferredPromise,
  createDevOrStagingUrlCache,
  createWorkerTimers,
  dateTo12HourTime,
  deepCamelToSnake,
  deepSnakeToCamel,
  deprecated,
  deprecatedObjectProperty,
  deprecatedProperty,
  deriveState,
  differenceInCalendarDays,
  extension,
  extractDevBrowserJWTFromURL,
  fastDeepMergeAndKeep,
  fastDeepMergeAndReplace,
  filterProps,
  formatRelative,
  getClerkJsMajorVersionOrTag,
  getCookieSuffix,
  getNonUndefinedValues,
  getScriptUrl,
  getSuffixedCookieName,
  handleValueOrFn,
  hasAlpha,
  hasLeadingSlash,
  hasTrailingSlash,
  hexStringToRgbaColor,
  iconImageUrl,
  inBrowser,
  is4xxError,
  isAbsoluteUrl,
  isBrowserOnline,
  isCaptchaError,
  isClerkAPIResponseError,
  isClerkRuntimeError,
  isCurrentDevAccountPortalOrigin,
  isDevelopmentEnvironment,
  isDevelopmentFromPublishableKey,
  isDevelopmentFromSecretKey,
  isEmailLinkError,
  isHSLColor,
  isHttpOrHttps,
  isIPV4Address,
  isKnownError,
  isLegacyDevAccountPortalOrigin,
  isMetamaskError,
  isNetworkError,
  isNonEmptyURL,
  isPasswordPwnedError,
  isProductionEnvironment,
  isProductionFromPublishableKey,
  isProductionFromSecretKey,
  isProxyUrlRelative,
  isPublishableKey,
  isRGBColor,
  isStaging,
  isTestEnvironment,
  isTransparent,
  isTruthy,
  isUnauthorizedError,
  isUserLockedError,
  isValidBrowser,
  isValidBrowserOnline,
  isValidHexString,
  isValidHslaString,
  isValidProxyUrl,
  isValidRgbaString,
  isomorphicAtob,
  isomorphicBtoa,
  joinURL,
  loadClerkJsScript,
  loadScript,
  logErrorInDevMode,
  logger,
  noop,
  normalizeDate,
  parseError,
  parseErrors,
  parsePublishableKey,
  parseSearchParams,
  proxyUrlToAbsoluteURL,
  readJSONFile,
  removeUndefined,
  runWithExponentialBackOff,
  setClerkJsLoadingErrorPackageName,
  setDevBrowserJWTInURL,
  snakeToCamel,
  stringToHslaColor,
  stringToSameTypeColor,
  stripScheme,
  titleize,
  toSentence,
  userAgentIsRobot,
  versionSelector,
  withLeadingSlash,
  withTrailingSlash,
  without,
  withoutLeadingSlash,
  withoutTrailingSlash
});
//# sourceMappingURL=index.js.map