import type { UseFloatingOptions } from '@floating-ui/react';
import { offset } from '@floating-ui/react';
import React from 'react';
type UsePopoverProps = {
    defaultOpen?: boolean;
    placement?: UseFloatingOptions['placement'];
    offset?: Parameters<typeof offset>[0];
    shoudFlip?: boolean;
    autoUpdate?: boolean;
    outsidePress?: boolean | ((event: MouseEvent) => boolean);
    adjustToReferenceWidth?: boolean;
    referenceElement?: React.RefObject<HTMLElement> | null;
    bubbles?: boolean | {
        escapeKey?: boolean;
        outsidePress?: boolean;
    };
};
export type UsePopoverReturn = ReturnType<typeof usePopover>;
export declare const usePopover: (props?: UsePopoverProps) => {
    reference: ((node: import("@floating-ui/react-dom").ReferenceType | null) => void) & ((node: import("@floating-ui/react").ReferenceType | null) => void);
    floating: ((node: HTMLElement | null) => void) & ((node: HTMLElement | null) => void);
    toggle: () => void;
    open: () => void;
    nodeId: string;
    close: () => void;
    isOpen: boolean;
    styles: {
        position: import("@floating-ui/utils").Strategy;
        top: number;
        left: number;
    };
    context: {
        strategy: import("@floating-ui/utils").Strategy;
        x: number;
        y: number;
        update: () => void;
        placement: import("@floating-ui/utils").Placement;
        middlewareData: import("@floating-ui/core").MiddlewareData;
        isPositioned: boolean;
        floatingStyles: React.CSSProperties;
        open: boolean;
        onOpenChange: (open: boolean, event?: Event) => void;
        events: import("@floating-ui/react").FloatingEvents;
        dataRef: React.MutableRefObject<import("@floating-ui/react").ContextData>;
        nodeId: string | undefined;
        floatingId: string;
        refs: import("@floating-ui/react").ExtendedRefs<import("@floating-ui/react").ReferenceType>;
        elements: import("@floating-ui/react").ExtendedElements<import("@floating-ui/react").ReferenceType>;
    };
};
export {};
