import type { OAuthProvider, OAuthStrategy, Web3Provider, Web3Strategy } from '@clerk/types';
type ThirdPartyStrategyToDataMap = {
    [k in Web3Strategy | OAuthStrategy]: {
        id: Web3Provider | OAuthProvider;
        iconUrl: string;
        name: string;
    };
};
type ThirdPartyProviderToDataMap = {
    [k in Web3Provider | OAuthProvider]: {
        strategy: Web3Strategy | OAuthStrategy;
        iconUrl: string;
        name: string;
    };
};
export declare const useEnabledThirdPartyProviders: () => {
    strategies: (OAuthStrategy | "web3_metamask_signature" | "web3_coinbase_wallet_signature")[];
    web3Strategies: ("web3_metamask_signature" | "web3_coinbase_wallet_signature")[];
    authenticatableOauthStrategies: OAuthStrategy[];
    strategyToDisplayData: ThirdPartyStrategyToDataMap;
    providerToDisplayData: ThirdPartyProviderToDataMap;
};
export {};
