import type { ClerkAPIError, ClerkRuntimeError } from '@clerk/types';
import React from 'react';
type Status = 'idle' | 'loading' | 'error';
type Metadata = string | undefined;
type State = {
    status: Status;
    metadata: Metadata;
    error: string | undefined;
};
declare const CardStateProvider: (props: React.PropsWithChildren<any>) => import("@emotion/react/jsx-runtime").JSX.Element;
declare const useCardState: () => {
    setIdle: (metadata?: Metadata) => void;
    setError: (metadata: ClerkRuntimeError | ClerkAPIError | Metadata | string) => void;
    setLoading: (metadata?: Metadata) => void;
    runAsync: <T = unknown>(cb: Promise<T> | (() => Promise<T>), metadata?: Metadata) => Promise<T>;
    loadingMetadata: Metadata;
    error: string | undefined;
    isLoading: boolean;
    isIdle: boolean;
    state: State;
};
export { useCardState, CardStateProvider };
export declare const withCardStateProvider: <T>(Component: React.ComponentType<T>) => (props: T) => import("@emotion/react/jsx-runtime").JSX.Element;
