import type { ActiveSessionResource, UserButtonProps, UserResource } from '@clerk/types';
type UseMultisessionActionsParams = {
    user: UserResource | null | undefined;
    actionCompleteCallback?: () => void;
    navigateAfterSignOut?: () => any;
    navigateAfterMultiSessionSingleSignOut?: () => any;
    navigateAfterSwitchSession?: () => any;
    afterSignInUrl?: string;
    userProfileUrl?: string;
    signInUrl?: string;
} & Pick<UserButtonProps, 'userProfileMode' | 'appearance' | 'userProfileProps'>;
export declare const useMultisessionActions: (opts: UseMultisessionActionsParams) => {
    handleSignOutSessionClicked: (session: ActiveSessionResource) => () => Promise<void>;
    handleManageAccountClicked: () => void | Promise<unknown>;
    handleUserProfileActionClicked: (__experimental_startPath?: string) => void | Promise<unknown>;
    handleSignOutAllClicked: () => Promise<void>;
    handleSessionClicked: (session: ActiveSessionResource) => () => Promise<void>;
    handleAddAccountClicked: () => Promise<unknown>;
    otherSessions: ActiveSessionResource[];
    activeSessions: ActiveSessionResource[];
};
export {};
