import type { __experimental_UserVerificationProps, Appearance, Clerk, ClerkOptions, EnvironmentResource, SignInProps, SignUpProps, UserProfileProps, WaitlistProps } from '@clerk/types';
import type { AppearanceCascade } from './customizables/parseAppearance';
import type { ClerkComponentName } from './lazyModules/components';
import type { AvailableComponentProps } from './types';
export type ComponentControls = {
    mountComponent: (params: {
        appearanceKey: Uncapitalize<AppearanceCascade['appearanceKey']>;
        name: ClerkComponentName;
        node: HTMLDivElement;
        props?: AvailableComponentProps;
    }) => void;
    unmountComponent: (params: {
        node: HTMLDivElement;
    }) => void;
    updateProps: (params: {
        appearance?: Appearance | undefined;
        options?: ClerkOptions | undefined;
        node?: HTMLDivElement;
        props?: unknown;
    }) => void;
    openModal: <T extends 'googleOneTap' | 'signIn' | 'signUp' | 'userProfile' | 'organizationProfile' | 'createOrganization' | 'userVerification' | 'waitlist'>(modal: T, props: T extends 'signIn' ? SignInProps : T extends 'signUp' ? SignUpProps : T extends 'userVerification' ? __experimental_UserVerificationProps : T extends 'waitlist' ? WaitlistProps : UserProfileProps) => void;
    closeModal: (modal: 'googleOneTap' | 'signIn' | 'signUp' | 'userProfile' | 'organizationProfile' | 'createOrganization' | 'userVerification' | 'waitlist', options?: {
        notify?: boolean;
    }) => void;
    prefetch: (component: 'organizationSwitcher') => void;
    mountImpersonationFab: () => void;
};
export declare const mountComponentRenderer: (clerk: Clerk, environment: EnvironmentResource, options: ClerkOptions) => {
    ensureMounted: (opts?: {
        preloadHint: ClerkComponentName;
    }) => Promise<ComponentControls>;
};
export type MountComponentRenderer = typeof mountComponentRenderer;
