import type { ClerkAPIError, PasskeyVerificationResource, PublicKeyCredentialCreationOptionsWithoutExtensions, SignUpVerificationJSON, SignUpVerificationResource, SignUpVerificationsJSON, SignUpVerificationsResource, VerificationJSON, VerificationResource, VerificationStatus } from '@clerk/types';
import { BaseResource } from './internal';
export declare class Verification extends BaseResource implements VerificationResource {
    pathRoot: string;
    status: VerificationStatus | null;
    strategy: string | null;
    nonce: string | null;
    message: string | null;
    externalVerificationRedirectURL: URL | null;
    attempts: number | null;
    expireAt: Date | null;
    error: ClerkAPIError | null;
    verifiedAtClient: string | null;
    constructor(data: VerificationJSON | null);
    verifiedFromTheSameClient: () => boolean;
    protected fromJSON(data: VerificationJSON | null): this;
}
export declare class PasskeyVerification extends Verification implements PasskeyVerificationResource {
    publicKey: PublicKeyCredentialCreationOptionsWithoutExtensions | null;
    constructor(data: VerificationJSON | null);
    /**
     * Transform base64url encoded strings to ArrayBuffer
     */
    protected fromJSON(data: VerificationJSON | null): this;
}
export declare class SignUpVerifications implements SignUpVerificationsResource {
    emailAddress: SignUpVerificationResource;
    phoneNumber: SignUpVerificationResource;
    web3Wallet: SignUpVerificationResource;
    externalAccount: VerificationResource;
    constructor(data: SignUpVerificationsJSON | null);
}
export declare class SignUpVerification extends Verification {
    nextAction: string;
    supportedStrategies: string[];
    constructor(data: SignUpVerificationJSON | null);
}
