import type { Attributes, OAuthProviders, OAuthStrategy, PasskeySettingsData, PasswordSettingsData, SamlSettings, SignInData, SignUpData, UserSettingsJSON, UserSettingsResource, Web3Strategy } from '@clerk/types';
import { BaseResource } from './internal';
export type Actions = {
    create_organization: boolean;
    delete_self: boolean;
};
/**
 * @internal
 */
export declare class UserSettings extends BaseResource implements UserSettingsResource {
    id: undefined;
    social: OAuthProviders;
    saml: SamlSettings;
    attributes: Attributes;
    actions: Actions;
    signIn: SignInData;
    signUp: SignUpData;
    passwordSettings: PasswordSettingsData;
    passkeySettings: PasskeySettingsData;
    socialProviderStrategies: OAuthStrategy[];
    authenticatableSocialStrategies: OAuthStrategy[];
    web3FirstFactors: Web3Strategy[];
    enabledFirstFactorIdentifiers: Array<keyof UserSettingsResource['attributes']>;
    constructor(data: UserSettingsJSON);
    get instanceIsPasswordBased(): boolean;
    get hasValidAuthFactor(): boolean;
    protected fromJSON(data: UserSettingsJSON | null): this;
    private getEnabledFirstFactorIdentifiers;
    private getWeb3FirstFactors;
    private getSocialProviderStrategies;
    private getAuthenticatableSocialStrategies;
}
