import type { __experimental_SessionVerificationResource, __experimental_SessionVerifyAttemptFirstFactorParams, __experimental_SessionVerifyAttemptSecondFactorParams, __experimental_SessionVerifyCreateParams, __experimental_SessionVerifyPrepareFirstFactorParams, __experimental_SessionVerifyPrepareSecondFactorParams, ActJWTClaim, CheckAuthorization, GetToken, SessionJSON, SessionResource, SessionStatus, TokenResource, UserResource } from '@clerk/types';
import { BaseResource, PublicUserData } from './internal';
export declare class Session extends BaseResource implements SessionResource {
    #private;
    pathRoot: string;
    id: string;
    status: SessionStatus;
    lastActiveAt: Date;
    lastActiveToken: TokenResource | null;
    lastActiveOrganizationId: string | null;
    actor: ActJWTClaim | null;
    user: UserResource | null;
    publicUserData: PublicUserData;
    __experimental_factorVerificationAge: [number, number] | null;
    expireAt: Date;
    abandonAt: Date;
    createdAt: Date;
    updatedAt: Date;
    static isSessionResource(resource: unknown): resource is Session;
    constructor(data: SessionJSON);
    end: () => Promise<SessionResource>;
    remove: () => Promise<SessionResource>;
    touch: () => Promise<SessionResource>;
    clearCache: () => void;
    getToken: GetToken;
    checkAuthorization: CheckAuthorization;
    __experimental_startVerification: ({ level, }: __experimental_SessionVerifyCreateParams) => Promise<__experimental_SessionVerificationResource>;
    __experimental_prepareFirstFactorVerification: (factor: __experimental_SessionVerifyPrepareFirstFactorParams) => Promise<__experimental_SessionVerificationResource>;
    __experimental_attemptFirstFactorVerification: (attemptFactor: __experimental_SessionVerifyAttemptFirstFactorParams) => Promise<__experimental_SessionVerificationResource>;
    __experimental_prepareSecondFactorVerification: (params: __experimental_SessionVerifyPrepareSecondFactorParams) => Promise<__experimental_SessionVerificationResource>;
    __experimental_attemptSecondFactorVerification: (params: __experimental_SessionVerifyAttemptSecondFactorParams) => Promise<__experimental_SessionVerificationResource>;
    protected fromJSON(data: SessionJSON | null): this;
    private _getToken;
}
