import type { ClerkPaginatedResponse, ClerkResourceReloadParams, GetUserOrganizationMembershipParams, OrganizationCustomRoleKey, OrganizationMembershipJSON, OrganizationMembershipResource, OrganizationPermissionKey } from '@clerk/types';
import { BaseResource, Organization, PublicUserData } from './internal';
export declare class OrganizationMembership extends BaseResource implements OrganizationMembershipResource {
    id: string;
    publicMetadata: OrganizationMembershipPublicMetadata;
    publicUserData: PublicUserData;
    organization: Organization;
    permissions: OrganizationPermissionKey[];
    role: OrganizationCustomRoleKey;
    createdAt: Date;
    updatedAt: Date;
    constructor(data: OrganizationMembershipJSON);
    static retrieve: GetOrganizationMembershipsClass;
    destroy: () => Promise<OrganizationMembership>;
    update: ({ role }: UpdateOrganizationMembershipParams) => Promise<OrganizationMembership>;
    protected fromJSON(data: OrganizationMembershipJSON | null): this;
    reload(_?: ClerkResourceReloadParams): Promise<this>;
}
export type UpdateOrganizationMembershipParams = {
    role: OrganizationCustomRoleKey;
};
export type GetOrganizationMembershipsClass = (params?: GetUserOrganizationMembershipParams) => Promise<ClerkPaginatedResponse<OrganizationMembership>>;
