import type { AuthConfigResource, DisplayConfigResource, EnvironmentJSON, EnvironmentResource, OrganizationSettingsResource, UserSettingsResource } from '@clerk/types';
import { BaseResource } from './internal';
export declare class Environment extends BaseResource implements EnvironmentResource {
    private static instance;
    pathRoot: string;
    authConfig: AuthConfigResource;
    displayConfig: DisplayConfigResource;
    userSettings: UserSettingsResource;
    organizationSettings: OrganizationSettingsResource;
    maintenanceMode: boolean;
    static getInstance(): Environment;
    constructor(data?: EnvironmentJSON | null);
    fetch({ touch }?: {
        touch: boolean;
    }): Promise<Environment>;
    isSingleSession: () => boolean;
    isProduction: () => boolean;
    isDevelopmentOrStaging: () => boolean;
    onWindowLocationHost: () => boolean;
    protected fromJSON(data: EnvironmentJSON | null): this;
}
