import type { AttemptEmailAddressVerificationParams, CreateEmailLinkFlowReturn, EmailAddressJSON, EmailAddressResource, IdentificationLinkResource, PrepareEmailAddressVerificationParams, StartEmailLinkFlowParams, VerificationResource } from '@clerk/types';
import { BaseResource } from './internal';
export declare class EmailAddress extends BaseResource implements EmailAddressResource {
    id: string;
    emailAddress: string;
    linkedTo: IdentificationLinkResource[];
    verification: VerificationResource;
    constructor(data: Partial<EmailAddressJSON>, pathRoot: string);
    create(): Promise<this>;
    prepareVerification: (params: PrepareEmailAddressVerificationParams) => Promise<this>;
    attemptVerification: (params: AttemptEmailAddressVerificationParams) => Promise<this>;
    createEmailLinkFlow: () => CreateEmailLinkFlowReturn<StartEmailLinkFlowParams, EmailAddressResource>;
    destroy: () => Promise<void>;
    toString: () => string;
    protected fromJSON(data: EmailAddressJSON | null): this;
}
