import type { CaptchaProvider, CaptchaWidgetType, DisplayConfigJSON, DisplayConfigResource, DisplayThemeJSON, OAuthStrategy, PreferredSignInStrategy } from '@clerk/types';
import { BaseResource } from './internal';
export declare class DisplayConfig extends BaseResource implements DisplayConfigResource {
    id: string;
    afterSignInUrl: string;
    afterSignOutAllUrl: string;
    afterSignOutOneUrl: string;
    afterSignOutUrl: string;
    afterSignUpUrl: string;
    afterSwitchSessionUrl: string;
    applicationName: string;
    backendHost: string;
    branded: boolean;
    captchaPublicKey: string | null;
    captchaWidgetType: CaptchaWidgetType;
    captchaProvider: CaptchaProvider;
    captchaPublicKeyInvisible: string | null;
    captchaOauthBypass: OAuthStrategy[];
    homeUrl: string;
    instanceEnvironmentType: string;
    faviconImageUrl: string;
    logoImageUrl: string;
    preferredSignInStrategy: PreferredSignInStrategy;
    signInUrl: string;
    signUpUrl: string;
    supportEmail: string;
    theme: DisplayThemeJSON;
    userProfileUrl: string;
    clerkJSVersion?: string;
    experimental__forceOauthFirst?: boolean;
    organizationProfileUrl: string;
    createOrganizationUrl: string;
    afterLeaveOrganizationUrl: string;
    afterCreateOrganizationUrl: string;
    googleOneTapClientId?: string;
    showDevModeWarning: boolean;
    termsUrl: string;
    privacyPolicyUrl: string;
    waitlistUrl: string;
    afterJoinWaitlistUrl: string;
    constructor(data: DisplayConfigJSON);
    protected fromJSON(data: DisplayConfigJSON | null): this;
}
