import type { ClerkResourceJSON, ClerkResourceReloadParams, DeletedObjectJSON } from '@clerk/types';
import type { FapiClient, FapiRequestInit, FapiResponseJSON, HTTPMethod } from '../fapiClient';
import type { Clerk } from './internal';
export type BaseFetchOptions = ClerkResourceReloadParams & {
    forceUpdateClient?: boolean;
};
export type BaseMutateParams = {
    action?: string;
    body?: any;
    method?: HTTPMethod;
    path?: string;
};
export declare abstract class BaseResource {
    static clerk: Clerk;
    id?: string;
    pathRoot: string;
    static get fapiClient(): FapiClient;
    protected static _fetch<J extends ClerkResourceJSON | DeletedObjectJSON | null>(requestInit: FapiRequestInit, opts?: BaseFetchOptions): Promise<FapiResponseJSON<J> | null>;
    protected static _updateClient<J>(responseJSON: FapiResponseJSON<J> | null): void;
    isNew(): boolean;
    protected path(action?: string): string;
    protected abstract fromJSON(data: ClerkResourceJSON | null): this;
    protected _baseGet<J extends ClerkResourceJSON | null>(opts?: BaseFetchOptions): Promise<this>;
    protected _baseMutate<J extends ClerkResourceJSON | null>({ action, body, method, path, }: BaseMutateParams): Promise<this>;
    protected _basePost<J extends ClerkResourceJSON | null>(params?: BaseMutateParams): Promise<this>;
    protected _basePut<J extends ClerkResourceJSON | null>(params?: BaseMutateParams): Promise<this>;
    protected _basePatch<J extends ClerkResourceJSON>(params?: BaseMutateParams): Promise<this>;
    protected _baseDelete<J extends ClerkResourceJSON | null>(params?: BaseMutateParams): Promise<void>;
    reload(params?: ClerkResourceReloadParams): Promise<this>;
}
