import type { Clerk, ClerkAPIErrorJSON, ClientJSON } from '@clerk/types';
export type HTTPMethod = 'CONNECT' | 'DELETE' | 'GET' | 'HEAD' | 'OPTIONS' | 'PATCH' | 'POST' | 'PUT' | 'TRACE';
export type FapiRequestInit = RequestInit & {
    path?: string;
    search?: ConstructorParameters<typeof URLSearchParams>[0];
    sessionId?: string;
    rotatingTokenNonce?: string;
    pathPrefix?: string;
    url?: URL;
};
export type FapiResponse<T> = Response & {
    payload: FapiResponseJSON<T> | null;
};
export type FapiRequestCallback<T> = (request: FapiRequestInit, response?: FapiResponse<T>) => Promise<unknown | false> | unknown | false;
export interface FapiResponseJSON<T> {
    response: T;
    client?: ClientJSON;
    errors?: ClerkAPIErrorJSON[];
    meta?: {
        client?: ClientJSON;
        session_id?: string;
    };
}
export interface FapiClient {
    buildUrl(requestInit: FapiRequestInit): URL;
    buildEmailAddress(localPart: string): string;
    onAfterResponse(callback: FapiRequestCallback<unknown>): void;
    onBeforeRequest(callback: FapiRequestCallback<unknown>): void;
    request<T>(requestInit: FapiRequestInit): Promise<FapiResponse<T>>;
}
export declare function createFapiClient(clerkInstance: Clerk): FapiClient;
