import type { TokenResource } from '@clerk/types';
export declare const events: {
    readonly TokenUpdate: "token:update";
};
type ClerkEvent = (typeof events)[keyof typeof events];
type EventHandler<E extends ClerkEvent> = (payload: EventPayload[E]) => void;
type TokenUpdatePayload = {
    token: TokenResource | null;
};
type EventPayload = {
    [events.TokenUpdate]: TokenUpdatePayload;
};
export declare const eventBus: {
    on: <E extends ClerkEvent>(event: E, handler: EventHandler<E>) => void;
    dispatch: <E extends ClerkEvent>(event: E, payload: EventPayload[E]) => void;
    off: <E extends ClerkEvent>(event: E, handler?: EventHandler<E>) => void;
};
export {};
