import { ConstructorOptions, ProviderInterface, RequestArguments, Signer } from '../core/provider/interface';
import { Chain } from '../core/type';
export declare function fetchRPCRequest(request: RequestArguments, chain: Chain): Promise<any>;
export interface CBWindow {
    coinbaseWalletSigner?: Signer;
    top: CBWindow;
    ethereum?: CBInjectedProvider;
    coinbaseWalletExtension?: CBInjectedProvider;
}
export interface CBInjectedProvider extends ProviderInterface {
    isCoinbaseBrowser?: boolean;
    setAppInfo?: (...args: unknown[]) => unknown;
}
export declare function getCoinbaseInjectedSigner(): Signer | undefined;
export declare function getCoinbaseInjectedProvider({ metadata, preference, }: Readonly<ConstructorOptions>): ProviderInterface | undefined;
/**
 * Validates the arguments for an invalid request and returns an error if any validation fails.
 * Valid request args are defined here: https://eips.ethereum.org/EIPS/eip-1193#request
 * @param args The request arguments to validate.
 * @returns An error object if the arguments are invalid, otherwise undefined.
 */
export declare function checkErrorForInvalidRequestArgs(args: RequestArguments): {
    code: number;
    data?: RequestArguments | undefined;
    name: string;
    message: string;
    stack?: string | undefined;
    cause?: unknown;
} | undefined;
