import {
  parsePublishableKey
} from "./chunk-L2BNNARM.mjs";
import {
  LEGACY_DEV_INSTANCE_SUFFIXES,
  LOCAL_API_URL,
  LOCAL_ENV_SUFFIXES,
  PROD_API_URL,
  STAGING_API_URL,
  STAGING_ENV_SUFFIXES
} from "./chunk-I6MTSTOF.mjs";

// src/apiUrlFromPublishableKey.ts
var apiUrlFromPublishableKey = (publishableKey) => {
  var _a;
  const frontendApi = (_a = parsePublishableKey(publishableKey)) == null ? void 0 : _a.frontendApi;
  if ((frontendApi == null ? void 0 : frontendApi.startsWith("clerk.")) && LEGACY_DEV_INSTANCE_SUFFIXES.some((suffix) => frontendApi == null ? void 0 : frontendApi.endsWith(suffix))) {
    return PROD_API_URL;
  }
  if (LOCAL_ENV_SUFFIXES.some((suffix) => frontendApi == null ? void 0 : frontendApi.endsWith(suffix))) {
    return LOCAL_API_URL;
  }
  if (STAGING_ENV_SUFFIXES.some((suffix) => frontendApi == null ? void 0 : frontendApi.endsWith(suffix))) {
    return STAGING_API_URL;
  }
  return PROD_API_URL;
};

export {
  apiUrlFromPublishableKey
};
//# sourceMappingURL=chunk-QPSU45F4.mjs.map