import type { MetamaskWeb3Provider } from '@clerk/types';
interface EIP1193Provider {
    isStatus?: boolean;
    host?: string;
    path?: string;
    sendAsync?: (request: {
        method: string;
        params?: [];
    }, callback: (error: Error | null, response: unknown) => void) => void;
    send?: (request: {
        method: string;
        params?: [];
    }, callback: (error: Error | null, response: unknown) => void) => void;
    request: (request: {
        method: string;
        params?: string[];
    }) => Promise<string>;
}
type InjectedWeb3Provider = MetamaskWeb3Provider;
declare class InjectedWeb3Providers {
    #private;
    private constructor();
    static getInstance(): InjectedWeb3Providers;
    get: (provider: InjectedWeb3Provider) => EIP1193Provider | undefined;
}
export declare const getInjectedWeb3Providers: () => InjectedWeb3Providers;
export {};
