declare const ClerkQueryParams: readonly ["__clerk_status", "__clerk_created_session", "__clerk_invitation_token", "__clerk_ticket", "__clerk_modal_state", "__clerk_handshake", "__clerk_help", "__clerk_synced", "__clerk_satellite_url", "suffixed_cookies"];
type ClerkQueryParam = (typeof ClerkQueryParams)[number];
type ClerkQueryParamsToValuesMap = {
    __clerk_status: VerificationStatus;
} & Record<(typeof ClerkQueryParams)[number], string>;
export type VerificationStatus = 'expired' | 'failed' | 'loading' | 'verified' | 'verified_switch_tab' | 'client_mismatch';
export declare function getClerkQueryParam<T extends ClerkQueryParam>(param: T): ClerkQueryParamsToValuesMap[T] | null;
export declare function removeClerkQueryParam<T extends ClerkQueryParam>(param: T): void;
export {};
