/**
 * Tracks beforeUnload events.
 *
 * Ideally we should not be always listening for the beforeUnload event
 * as it effectively disables the browser's BF cache.

 * To avoid this limitation, use the startTracking/ stopTracking methods
 * to listen for the event just before potential navigation is about to happen
 *
 * @internal
 */
export declare const createBeforeUnloadTracker: () => {
    startTracking: () => void;
    stopTracking: () => void;
    isUnloading: () => boolean;
};
