import type { ClerkAPIError, ClerkRuntimeError } from '@clerk/types';
import type { FormControlState } from './useFormControl';
type HandleError = {
    (err: Error, fieldStates: Array<FormControlState<string>>, setGlobalError?: (err: ClerkRuntimeError | ClerkAPIError | string | undefined) => void): void;
};
export declare const handleError: HandleError;
export declare function getGlobalError(err: Error): ClerkAPIError | undefined;
export declare function getFieldError(err: Error): ClerkAPIError | undefined;
export declare function getClerkAPIErrorMessage(err: ClerkAPIError): string;
export {};
