import type { ClerkHostRouter } from '@clerk/shared/router';
import type { ClerkOptions, LoadedClerk } from '@clerk/types';
import type { ClerkNewComponents, ComponentDefinition } from './types';
export declare class UI {
    #private;
    router?: ClerkHostRouter;
    clerk: LoadedClerk;
    options: ClerkOptions;
    componentRegistry: Map<string, ComponentDefinition>;
    constructor({ router, clerk, options, }: {
        router: ClerkHostRouter | undefined;
        clerk: LoadedClerk;
        options: ClerkOptions;
    });
    mount<C extends keyof ClerkNewComponents>(componentName: C, node: HTMLElement, props: ClerkNewComponents[C]): void;
    unmount(node: HTMLElement): void;
    register(componentName: string, componentDefinition: ComponentDefinition): void;
    renderer(): Promise<unknown>;
}
