import React from 'react';
import type { ThemableCssProp } from '../styledSystem';
import type { ElementDescriptor, ElementId } from './elementDescriptors';
type Customizable<T = Record<never, never>> = T & {
    elementDescriptor?: ElementDescriptor | Array<ElementDescriptor | undefined>;
    elementId?: ElementId;
    css?: never;
    sx?: ThemableCssProp;
};
type CustomizablePrimitive<T> = React.FunctionComponent<Customizable<T>>;
type MakeCustomizableOptions = {
    defaultStyles?: ThemableCssProp;
    defaultDescriptor?: ElementDescriptor;
};
export declare const makeCustomizable: <P>(Component: React.FunctionComponent<P>, options?: MakeCustomizableOptions) => CustomizablePrimitive<P>;
export {};
