import type { OrganizationEnrollmentMode, OrganizationSettingsJSON, OrganizationSettingsResource } from '@clerk/types';
import { BaseResource } from './internal';
export declare class OrganizationSettings extends BaseResource implements OrganizationSettingsResource {
    enabled: boolean;
    maxAllowedMemberships: number;
    actions: {
        adminDelete: boolean;
    };
    domains: {
        enabled: boolean;
        enrollmentModes: OrganizationEnrollmentMode[];
        defaultRole: string | null;
    };
    constructor(data: OrganizationSettingsJSON);
    protected fromJSON(data: OrganizationSettingsJSON | null): this;
}
