import type { ActiveSessionResource, ClientJSON, ClientResource, SignInResource, SignUpResource } from '@clerk/types';
import { BaseResource, Session } from './internal';
export declare class Client extends BaseResource implements ClientResource {
    private static instance;
    pathRoot: string;
    sessions: Session[];
    signUp: SignUpResource;
    signIn: SignInResource;
    lastActiveSessionId: string | null;
    cookieExpiresAt: Date | null;
    createdAt: Date | null;
    updatedAt: Date | null;
    static getInstance(): Client;
    static isClientResource(resource: unknown): resource is Client;
    private constructor();
    get signUpAttempt(): SignUpResource;
    get signInAttempt(): SignInResource;
    get activeSessions(): ActiveSessionResource[];
    create(): Promise<this>;
    fetch(): Promise<this>;
    destroy(): Promise<void>;
    removeSessions(): Promise<ClientResource>;
    clearCache(): void;
    isEligibleForTouch(): boolean;
    buildTouchUrl({ redirectUrl }: {
        redirectUrl: URL;
    }): string;
    fromJSON(data: ClientJSON | null): this;
    protected path(): string;
}
