import type { Clerk, EnvironmentResource } from '@clerk/types';
import type { FapiClient } from '../fapiClient';
/**
 * The AuthCookieService class is a service responsible to handle
 * all operations and helpers required in a standard browser context
 * based on the cookies to remove the dependency between cookies
 * and auth from the Clerk instance.
 * This service is responsible to:
 *   - refresh the session cookie using a poller
 *   - refresh the session cookie on tab visibility change
 *   - update the related cookies listening to the `token:update` event
 *   - initialize auth related cookies for development instances (eg __client_uat, __clerk_db_jwt)
 *   - cookie setup for production / development instances
 * It also provides the following helpers:
 *   - isSignedOut(): check if the current user is signed-out using cookies
 *   - decorateUrlWithDevBrowserToken(): decorates url with auth related info (eg dev browser jwt)
 *   - handleUnauthenticatedDevBrowser(): resets dev browser in case of invalid dev browser
 *   - setEnvironment(): update cookies (eg client_uat) related to environment
 */
export declare class AuthCookieService {
    private clerk;
    private environment;
    private poller;
    private clientUat;
    private sessionCookie;
    private devBrowser;
    static create(clerk: Clerk, fapiClient: FapiClient): Promise<AuthCookieService>;
    private constructor();
    setEnvironment(environment: EnvironmentResource): void;
    isSignedOut(): boolean;
    setupDevelopment(): Promise<void>;
    setupProduction(): void;
    handleUnauthenticatedDevBrowser(): Promise<void>;
    decorateUrlWithDevBrowserToken(url: URL): URL;
    private startPollingForToken;
    private refreshTokenOnFocus;
    private refreshSessionToken;
    private updateSessionCookie;
    private setClientUatCookieForDevelopmentInstances;
    private inCustomDevelopmentDomain;
    private handleGetTokenError;
    /**
     * The below methods are used to determine whether or not an unfocused tab can be responsible
     * for setting the session cookie. A session cookie should only be set by a tab who's selected
     * organization matches the session's active organization. By storing the active organization
     * ID in local storage, we can check the value across tabs. If a tab's organization ID does not
     * match the value in local storage, it is not responsible for updating the session cookie.
     */
    setActiveOrganizationInStorage(): void;
    private isCurrentOrganizationActive;
}
